#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Columnas opRevolution-v2Mod01.fsh   by   jorge2017a2
//https://www.shadertoy.com/view/ft2yWc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------image
//por jorge2017a2-
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define Ka 0.5
#define Kd 0.4
//  Start Common  //
//-------common
#define PI 3.14159265
///Gracias a Shane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
  n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
  n /= dot(n, vec3(1)); 
  vec3 tx = texture2D(tex, p.yz).xyz;
  vec3 ty = texture2D(tex, p.zx).xyz;
  vec3 tz = texture2D(tex, p.xy).xyz;
  return mat3(tx*tx, ty*ty, tz*tz)*n; 
}

vec3  Arrcolores[] = vec3[] (
vec3(0,0,0),  //0
vec3(1.,1.,1.), //1
vec3(1,0,0),  //2
vec3(0,1,0),   //3
vec3(0,0,1),   //4
vec3(1,1,0),  //5
vec3(0,1,1)  //6 
);

vec3 getColor(int i)
{ if (i>-1 )  return Arrcolores[i];}

//  End Common  //
//Columnas v3 opRevolution --18-abril-2022
//referencia
//https://iquilezles.org/articles/distfunctions2d/
//https://iquilezles.org/articles/distfunctions/

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU2(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }
float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }

///----------Operacion de Distancia--------
float Intersect(float distA, float distB)
	{ return max(distA, distB);}
float Union(float distA, float distB)
	{ return min(distA, distB);}
float Difference(float distA, float distB)
	{ return max(distA, -distB);}
//----------oPeraciones de Repeticion
float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}

// object transformation
vec3 rotate_x(vec3 p, float phi)
{   float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
vec2 rotatev2(vec2 p, float ang)
{   float c = cos(ang); float s = sin(ang);
    return vec2(p.x*c - p.y*s, p.x*s + p.y*c);
}


float sdTriangleIsosceles( in vec2 p, in vec2 q )
{
    p.x = abs(p.x);
    vec2 a = p - q*clamp( dot(p,q)/dot(q,q), 0.0, 1.0 );
    vec2 b = p - q*vec2( clamp( p.x/q.x, 0.0, 1.0 ), 1.0 );
    float s = -sign( q.y );
    vec2 d = min( vec2( dot(a,a), s*(p.x*q.y-p.y*q.x) ),
                  vec2( dot(b,b), s*(p.y-q.y)  ));
    return -sqrt(d.x)*sign(d.y);
}

float sdBox( in vec2 p, in vec2 b )
{ vec2 d = abs(p)-b;  return length(max(d,0.0)) + min(max(d.x,d.y),0.0);  }

float sdUnevenCapsule( vec2 p, float r1, float r2, float h )
{
    p.x = abs(p.x);
    float b = (r1-r2)/h;
    float a = sqrt(1.0-b*b);
    float k = dot(p,vec2(-b,a));
    if( k < 0.0 ) return length(p) - r1;
    if( k > a*h ) return length(p-vec2(0.0,h)) - r2;
    return dot(p, vec2(a,b) ) - r1;
}

float ficuraPostev2(vec2 p)
{  float r1,r2,h;
    p=vec2(p.y, p.x)-vec2(0.0+6.0,0.0);
    float d0= sdBox( p-vec2(0.7,2.2),vec2(0.5,3.5) );
    r1=0.5;r2=0.5;h=4.5; 
    float d1= sdUnevenCapsule( p,r1,r2, h );
    r1=0.5;r2=0.5;h=3.5; 
    float d2= sdUnevenCapsule( p-vec2(-1.0,0.5),r1,r2, h );    
    float res= Union(d0, d1);
    res= Union(res, d2);
    return res;
}

float figuraPosteUnion(vec2 p)
{   float d0= ficuraPostev2(p);
    float d1= sdBox( p-vec2(2.25,-1.0),vec2(0.5,7.5) );
    float d3= ficuraPostev2(vec2(p.x,-p.y-3.0));
    float res=Union(d0, d1);
    res=Union(res, d3);   
    return res;
}
// iq formula
vec2 opRevolution( in vec3 p, float w )
{  return vec2( length(p.xz) - w, p.y ); }


vec2 figuraPoste3d(vec3 p)
{   p.y-=11.5;
    vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
    vec2 qrev=opRevolution(p,0.5);
    float d1= figuraPosteUnion(qrev);
    float d2=sdCylinderXZ( p, vec2(4.0,6.0)  );
    res =opU2(res, vec2(d1,100.0));
    return res;
}

vec2 cuatroPostes(vec3 p)
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
    p.x=abs(p.x)-15.0;
    p.z=abs(p.z)-10.0;
    vec2  re1= figuraPoste3d(p);
    res =opU2(res, re1);    
    return res;
}

vec2 piramideEncima(vec3 p)
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
    vec2 q=vec2(p.x, -p.y);
    float d1= sdTriangleIsosceles(q-vec2(0.0,-22.0), vec2(15.0,8.5) );
    float d2= sdTriangleIsosceles(q-vec2(0.0,-19.0), vec2(12.0,6.0) );
    float d3= sdBox( p-vec3(0.0,20.0,0.0), vec3(16.0,8.0,15.0) );
    d1= Difference(d1, d2);
    d1=Intersect(d1,d3);
    res =opU2(res, vec2(d1,102.0));
    return res;
}

vec2 TdoJunto(vec3 p)
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
    vec2 re2= cuatroPostes(p);
    res =opU2(res, re2);
    
    vec2 re3= piramideEncima(p-vec3(0.0,5.0,0.0));
    res =opU2(res, re3);
 return res;
}   

vec2 GetDist(vec3 p  ) 
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
	float planeDist1 = p.y-1.0;  //piso inf
    res =opU2(res, vec2(planeDist1,57.0));
    p.x= opRep1D( p.x, 50.0 );
    p.z= opRep1D( p.z, 40.0 );
    vec2 re1= TdoJunto(p);
    res =opU2(res, re1);
    return res;
}

vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

vec2 RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   vec3 p;
    vec2 hit, object=vec2(0.1,0.0);
    for(int i=0; i <= PMaxSteps; i++) 
    { p = ro + rd*object.x;
      hit = GetDist(p);
      object.x += hit.x;
      object.y = hit.y;
      if (abs(hit.x) < EPSILON || object.x > MAX_DIST) break;
    }    
    return object;
}

float getSoftShadow(vec3 p, vec3 lightPos) {
    float res = 9999.0;
    float dist = 0.01;
    float lightSize = 0.03;
    for (int i = 0; i < MAX_STEPS; i++) {
      float hit = GetDist(p + lightPos * dist).x;
      res = min(res, hit / (dist * lightSize));
      dist += hit;
      if (hit < 0.0001 || dist > 60.0) break;
    }
    return clamp(res, 0.0, 1.0);
}

float occlusion(vec3 pos, vec3 nor)
{   float sca = 2.0, occ = 0.0;
    for(int i = 0; i < 10; i++) {    
      float hr = 0.01 + float(i) * 0.5 / 4.0;
      float dd = GetDist(nor * hr + pos).x;
      occ += (hr - dd)*sca;
      sca *= 0.6;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 lightColor, float t) 
{   vec3 lightPos=lp;
    vec3 worldPos = p;
    vec3 V = -rd;
    vec3 N = normal;
    vec3 L = normalize (lightPos - worldPos);
    vec3 R = reflect (-L, N);

    float lightDist = max(length(L), .001);
    float atten=1.0 / (1.0 + lightDist * 0.125 + lightDist * lightDist * .05);
    L /= (lightDist*atten);

    float shadow = getSoftShadow(worldPos, L);// shadows
        
    float occ = occlusion(worldPos, N);// occ
    vec3 ambient = Ka + Ka * dot(normal, vec3(0., 1., 0.))*lightColor;
    ambient*=0.5;

    vec3 fresnel =  lightColor *  pow(clamp(1.0 + dot(rd, N), 0.0, 1.0), 2.0);;
    float diff= clamp(dot(N, L), 0.0, 1.0);
    vec3 diffuse =  lightColor * diff;
    float shininess=10.0;
    float specular    = pow(max(dot(R, V), 0.0), shininess);

    vec3 back = 0.5 * lightColor * clamp(dot(N, -L), 0.0, 1.0); // back
    vec3 colOut = occ*lightColor*(ambient+diffuse*shadow+.25 +back) + vec3(.7,.9,1)*specular*specular;
    return colOut;
}

vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	if (i==100 )
    { vec3 col=tex3D(texture0, p/32., nor); return col*2.0; }
	if (i==101 ) { return tex3D(texture1, p/32., nor); }
	if (i==102 ) { return tex3D(texture0, p/32., nor)*vec3(1.0,2.0,1.0); }
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}

//https://www.shadertoy.com/view/4lcSRn   ///IQ
vec3 pattern( in vec2 uv )
{   vec3 col = vec3(0.4);
    col += 0.4*smoothstep(-0.01,0.02,cos(uv.x*0.5)*cos(uv.y*0.5)); 
    col *= smoothstep(-1.0,-0.98,cos(uv.x))*smoothstep(-1.0,-0.98,cos(uv.y));
    return col;
}

vec3 GetMaterial(vec3 p,  vec3 nor, vec3 ro,  vec3 rd, int id_color)
{  	vec3 colobj; 
     if (id_color<40) { colobj=getColor(int( id_color));  return colobj; }
    if (id_color==57) {return pattern( p.xz );}
 if (id_color>=100 )
   { return  getColorTextura( p, nor,id_color); }
}

vec3 linear2srgb(vec3 c) 
{ return mix(12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055, step(vec3(0.0031308), c)); }

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{ return vec3(1.0) - exp(-hdrColor * exposure); }

vec3 ACESFilm(vec3 x)
{   float a,b,c,d,e;
    a = 2.51; b = 0.03; c = 2.43;d = 0.59; e = 0.14;
    return (x*(a*x+b))/(x*(c*x+d)+e);
}

vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
  vec3 p;
     vec2 hit=RayMarch(ro,rd, MAX_STEPS);
      if(hit.x<MAX_DIST)
       {   p = (ro + rd * hit.x );
        vec3 nor=GetNormal(p);
        vec3 colobj;
        colobj=GetMaterial( p, nor, ro, rd,  int(hit.y));
        vec3 result;
         result= lightingv3(nor, p,light_pos1, rd,ro,colobj,hit.x)*light_color1;
        result+= lightingv3(nor, p,light_pos2,rd, ro,colobj,hit.x)*light_color2;
        col= result/2.0;
        col= (ACESFilm(col)+linear2srgb(col)+col+ exposureToneMapping(3.0, col))/4.0 ;
    }
    else if(hit.x>MAX_DIST)
    col= render_sky_color(rd);
   return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    float t=mod(iTime*10.0,1000.0);
 	light_pos1= vec3(-10.0, 50.0, -25.); light_color1=vec3( 1.0,1.0,1.0 );
 	light_pos2= vec3(10.0, 20.0, -25.0 ); light_color2 =vec3( 1.0,1.0,1.0 ); 
   vec3 ro=vec3(0.0,7.0,-35.0+t);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
   rd= rotate_x(rd, radians(-30.0+abs(30.0*sin(iTime*0.25))));
   
    light_pos1+=ro;
    light_pos2+=ro;
    vec3 col= Render( ro,  rd);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

